 ; Ŀ
 ;   Rocket: converts text strings in the "12 1/2" format into "12[1\2]"   
 ;   for use with Rocket Software's font Rocket.shx.                       
 ;   Copyright 1992, 1996 by Rocket Software.                              
 ;   This program is guaranteed foolproof for fools up to Milspec XE-69-4. 
 ; 

 ; Ŀ
 ;   Subroutine Rocket: da brane.                                          
 ; 
 (DEFUN ROCKET (txnum / txlen nustr len spac1 spac2)
 ; Ŀ
 ;   Remove any leading or trailing spaces from text string.               
 ; 
  (while (= (substr txnum 1 1) " ")
         (setq txnum (substr txnum 2)))
  (while (= (substr txnum (strlen txnum) 1) " ")
         (setq txnum (substr txnum 1 (1- (strlen txnum)))))
 ; Ŀ
 ;   Position of the first slash = len, first space = spac1,               
 ;   2nd space or " = spac2.                                               
 ; 
  (setq nustr "")
  (while (/= txnum "")
   (setq len 1)
   (setq txlen (strlen txnum))
   (while (and (>= txlen len) (/= (substr txnum len 1) "/"))
          (setq len (1+ len)))                               ; / pos
   (if (<= len txlen)
       (progn
            (setq spac1 (setq spac2 (setq slapos len)))
            (while (and (>= spac1 1) (/= (substr txnum spac1 1) " "))
                   (setq spac1 (1- spac1)))                  ; first space pos
            (while (and (<= spac2 txlen)
                        (/= (substr txnum spac2 1) " ")
                        (/= (substr txnum spac2 1) (chr 34))); (chr 34) = "
                   (setq spac2 (1+ spac2)))                  ; 2nd space or "
 ; Ŀ
 ;   Now dismantle the string, take out / and spaces as needed,            
 ;   and put in [, \, and ].                                               
 ; 
            (setq nustr (strcat nustr 
 ; Ŀ
 ;   Strcat nustr and whatever is before the first space ("" if nothing).  
 ; 
                               (cond ((<= spac1 1) "")
                                     (T (substr txnum 1 (1- spac1))))
 ; Ŀ
 ;   If the char before the space is text then put in a space, if it's a   
 ;   number then put in "" = nothing, if there is no previous character    
 ;   and you try to read it acad will crash, so if spac1 <= 1 then "",     
 ;   and if for some wierd reason there is a " put in a space.             
 ; 
                               (cond ((<= spac1 1) "")
                                     ((= (substr txnum (- spac1 1) 1)
                                         (chr 34)) " ")
 ; Ŀ
 ;   The next two lines are included to test for a right bracket in the    
 ;   position before the space - when the routine tests to see if the      
 ;   character is an integer it reads it and gets a bracket, which not     
 ;   being enclosed in a string (because it was read) crashes the routine. 
 ;   The remedy is to check for a bracket before checking for an integer.  
 ; 
                                     ((= (substr txnum (- spac1 1) 1)
                                         (chr 41)) " ")   ; 41 = right bracket
                                     ((= (type (read
                                         (substr txnum (- spac1 1) 1))) 'INT)
                                          "")
                                     (T " "))
 ; Ŀ
 ;   Now you're at the start of the fraction, so strcat in the [.          
 ; 
                               "["
 ; Ŀ
 ;   The text from the space to before the /.  (If there was no text       
 ;   before the fraction - ie no space was found and spac1 = 1 or 0, then  
 ;   the numerator = everything from the start to the /.)                  
 ; 
                                (cond ((<= spac1 1)
                                      (substr txnum 1 (- len 1)))
                                      (T (substr txnum (1+ spac1)
                                                       (- len spac1 1))))
 ; Ŀ
 ;   Add the backslash which Rocket.shx will convert to a slash etc.       
 ; 
                                (chr 92)                      ; = \
 ; Ŀ
 ;   The text from the / to the next space.  If there is no space and      
 ;   spac2 is greater than the string length everything from the / on.     
 ; 
                                (cond ((> spac2 txlen)
                                       (substr txnum (1+ len)))
                                      (T (substr txnum (1+ len)
                                                       (- spac2 (1+ len)))))
 ; Ŀ
 ;   The final ] converts the text height back to the original one.        
 ; 
                               "]"))
            (setq txnum (substr txnum spac2)))
       (progn
            (setq nustr (strcat nustr txnum))
            (setq txnum ""))))
 nustr)
 ; Ŀ
 ;   Rocket end.                                                           
 ; 

 ; Ŀ
 ;   Rocket: gives the orders but isn't sure what they mean.               
 ;   Remind you of anyone?                                                 
 ; 
 (DEFUN C:ROCKET (/ ss num entt zz gnuz)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (prompt "Select Text: ")
  (setq ss (ssget (list (cons 0 "TEXT"))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq entt (entget enam))
         (setq num (1+ num))
         (setq zz (cdr (assoc 1 entt)))
         (setq gnuz (rocket zz))
         (entmod (subst (cons 1 gnuz) (cons 1 zz) entt)))
 (princ))